# Authorize.Net Payment Gateway Module

## Overview

This module integrates the Authorize.Net payment gateway into the application, primarily for handling subscriptions via Automated Recurring Billing (ARB) and potentially one-time payments.

## Features

- Authorize.Net API integration.
- Management of Authorize.Net API credentials (API Login ID, Transaction Key, Signature Key) and Mode (Sandbox/Live) via admin settings.
- Webhook handling for key Authorize.Net events (e.g., subscription status changes, payment success/failure).

## Setup & Configuration

1.  **Install Dependencies:**
    This module uses the official Authorize.Net PHP SDK.
    ```bash
    composer require authorizenet/authorizenet-php-sdk
    ```

2.  **Database Migrations:**
    *   The `subscription_plans` table can have an `authorizenet_plan_id` column if you need to map your internal plans to specific Authorize.Net plan identifiers (though ARB subscriptions are often more dynamic).
    *   You will likely need to store Authorize.Net Customer Profile IDs and Payment Profile IDs, typically associated with your `users` table or a dedicated `payment_methods` table. These migrations would be added as needed.
    *   Run module migrations: `php artisan module:migrate AuthorizeNetGateway`

3.  **Environment Variables (Fallback):**
    While settings are managed via the admin panel, you can have fallback values in your main `.env` file:
    ```env
    AUTHORIZENET_LOGIN_ID=your_sandbox_api_login_id
    AUTHORIZENET_TRANSACTION_KEY=your_sandbox_transaction_key
    AUTHORIZENET_SIGNATURE_KEY=your_sandbox_signature_key
    AUTHORIZENET_MODE=sandbox
    ```
    Replace with your Live credentials for production after thorough testing.

4.  **Admin Configuration:**
    *   Navigate to `Admin Panel > Modules > Authorize.Net Settings`.
    *   Select the Mode (Sandbox or Live).
    *   Enter your API Login ID, Transaction Key, and Signature Key.
    *   Enable the Authorize.Net Gateway.

5.  **Authorize.Net Merchant Interface Setup:**
    *   **API Credentials:** Obtain your API Login ID and Transaction Key from your Authorize.Net Merchant Interface (Account > Settings > API Credentials & Keys).
    *   **Signature Key:** Generate a Signature Key for webhook verification (Account > Settings > Webhooks > Add Endpoint > Get Signature Key).
    *   **Webhook Endpoint:**
        *   In your Authorize.Net Merchant Interface (Account > Settings > Webhooks), add an endpoint.
        *   Set the "Endpoint URL" to: `YOUR_APP_URL/webhooks/authorizenet` (e.g., `https://yourdomain.com/webhooks/authorizenet`). For local development, use a tunneling service like ngrok.
        *   Select the events you want to subscribe to (e.g., `net.authorize.payment.authcapture.created`, `net.authorize.customer.subscription.created`, `net.authorize.customer.subscription.cancelled`, etc.).

6.  **CSRF Exemption:**
    Ensure the Authorize.Net webhook route (`webhooks/authorizenet`) is added to the `$except` array in `app/Http/Middleware/VerifyCsrfToken.php`.

## Webhook Handling

The module will require a controller and route to handle incoming webhooks from Authorize.Net. It's crucial that webhook signature verification (using the Signature Key) is implemented for security.