<?php

namespace Modules\AuthorizeNetGateway\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Setting; // Assuming your Setting model is in App\Models
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class AuthorizeNetConfigController extends Controller
{
    /**
     * Show the form for editing the Authorize.Net settings.
     *
     * @return \Illuminate\View\View
     */
    public function edit()
    {
        // Keys for Authorize.Net settings
        $settingKeys = [
            'authorizenet_enabled',
            'authorizenet_mode',
            'authorizenet_login_id',
            'authorizenet_transaction_key',
            'authorizenet_signature_key',
            'authorizenet_public_client_key',
        ];

        $settings = [];
        foreach ($settingKeys as $key) {
            $settings[$key] = Setting::getValue($key);
        }

        // Default 'authorizenet_enabled' to '0' if null (not yet saved)
        if (is_null($settings['authorizenet_enabled'])) {
            $settings['authorizenet_enabled'] = '0';
        }
        // Default 'authorizenet_mode' to 'sandbox' if null
        if (is_null($settings['authorizenet_mode'])) {
            $settings['authorizenet_mode'] = 'sandbox';
        }

        return view('authorizenetgateway::admin.config', compact('settings'));
    }

    /**
     * Update the Authorize.Net settings in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(Request $request)
    {
        $request->validate([
            'authorizenet_enabled' => 'nullable|boolean', // Checkbox might not be present if unchecked
            'authorizenet_mode' => 'required|in:sandbox,live',
            'authorizenet_login_id' => 'nullable|string|max:255',
            'authorizenet_transaction_key' => 'nullable|string|max:255',
            'authorizenet_signature_key' => 'nullable|string|max:255',
            'authorizenet_public_client_key' => 'nullable|string|max:255',
        ]);

        try {
            Setting::setValue('authorizenet_enabled', $request->input('authorizenet_enabled', '0'), 'Enable Authorize.Net Gateway', 'Payment Gateways', 'boolean');
            Setting::setValue('authorizenet_mode', $request->input('authorizenet_mode', 'sandbox'), 'Authorize.Net Mode', 'Payment Gateways', 'select');
            Setting::setValue('authorizenet_login_id', $request->input('authorizenet_login_id'), 'Authorize.Net API Login ID', 'Payment Gateways', 'text');
            Setting::setValue('authorizenet_transaction_key', $request->input('authorizenet_transaction_key'), 'Authorize.Net Transaction Key', 'Payment Gateways', 'password');
            Setting::setValue('authorizenet_signature_key', $request->input('authorizenet_signature_key'), 'Authorize.Net Signature Key (Webhooks)', 'Payment Gateways', 'password');
            Setting::setValue('authorizenet_public_client_key', $request->input('authorizenet_public_client_key'), 'Authorize.Net Public Client Key', 'Payment Gateways', 'text');

            return redirect()->route('admin.authorizenetgateway.settings.edit')->with('success', 'Authorize.Net settings updated successfully.');
        } catch (\Exception $e) {
            Log::error('Error updating Authorize.Net settings: ' . $e->getMessage());
            return redirect()->route('admin.authorizenetgateway.settings.edit')->with('error', 'Failed to update Authorize.Net settings. Please try again.');
        }
    }
}