<?php

use Illuminate\Support\Facades\Route;
use Modules\AppManager\Http\Controllers\Api\ActivationController;
use Modules\AppManager\Http\Controllers\Api\ActivationValidationController;
use Modules\AppManager\Http\Controllers\Api\FileDownloadController;

Route::group([], function () { 
    Route::post('activate', [ActivationController::class, 'activate'])->name('activate');
    Route::post('validate-license', [ActivationController::class, 'validateLicense'])->name('validate'); // For periodic checks
    Route::post('download-file', [FileDownloadController::class, 'download'])->name('download.file');
    Route::post('validate-activation', [ActivationValidationController::class, 'validateActivation'])->name('validate.activation');
});