<?php

use Illuminate\Support\Facades\Route;
use Modules\AppManager\Http\Controllers\Admin\ManagedScriptController;
use Modules\AppManager\Http\Controllers\Admin\LicenseController;
use Modules\AppManager\Http\Controllers\Admin\ActivationLogController;
use Modules\AppManager\Http\Controllers\Admin\DownloadableFileController;
use App\Http\Middleware\IsAdminMiddleware;

// Assuming a global 'admin/' prefix is applied by the main application

// The main app/Providers/RouteServiceProvider.php applies 'admin/appmanager/' prefix
// and 'admin.appmanager.' name prefix.
Route::middleware(['web', IsAdminMiddleware::class])
    ->group(function () {
        Route::resource('scripts', ManagedScriptController::class);
        Route::resource('scripts.files', DownloadableFileController::class)->except(['show']); // files nested under scripts

        Route::resource('licenses', LicenseController::class);
        Route::get('activation-logs', [ActivationLogController::class, 'index'])->name('activationlogs.index');
        // Add other AppManager admin routes here
    });

// Note: Ensure your controller namespaces are correct, e.g.,
// Modules\AppManager\Http\Controllers\Admin\ManagedScriptController