@extends('layouts.admin') {{-- Or your AppManager specific admin layout if different --}}

@section('title', 'Edit Script: ' . $script->name)
@section('header_title', 'Edit Script/Application: ' . $script->name)

@section('content')
<div class="container px-6 mx-auto grid">
    <div class="my-6">
        <a href="{{ route('admin.appmanager.scripts.show', $script) }}" class="text-purple-600 hover:text-purple-800 dark:text-purple-400 dark:hover:text-purple-200 mb-4 inline-block">
            &larr; Back to Script Details
        </a>
        <div class="p-6 bg-white rounded-lg shadow-md dark:bg-gray-800">
            <h2 class="text-xl font-semibold text-gray-700 dark:text-gray-200 mb-4">
                Edit {{ $script->name }}
            </h2>

            <form method="POST" action="{{ route('admin.appmanager.scripts.update', $script) }}">
                @csrf
                @method('PUT') {{-- Important for update operations --}}
                @include('appmanager::admin.managed_scripts._form', ['script' => $script, 'statuses' => $statuses])
            </form>
        </div>
    </div>
</div>
@endsection