@extends('layouts.admin')

@section('title', 'License Details: ' . $license->license_key)
@section('header_title', 'License Details: ' . Str::limit($license->license_key, 40))

@section('content')
<div class="mb-4">
    <a href="{{ route('admin.appmanager.licenses.index') }}" class="text-purple-600 hover:text-purple-800 dark:text-purple-400 dark:hover:text-purple-200">&larr; Back to Licenses</a>
</div>

<div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
    <div class="p-6 lg:p-8">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
            <div>
                <h4 class="font-semibold text-gray-700 dark:text-gray-300">License Key:</h4>
                <p class="text-gray-900 dark:text-gray-100 break-all">{{ $license->license_key }}</p>
            </div>
            <div>
                <h4 class="font-semibold text-gray-700 dark:text-gray-300">Script:</h4>
                <p class="text-gray-900 dark:text-gray-100">{{ $license->managedScript->name ?? 'N/A' }}</p>
            </div>
            <div>
                <h4 class="font-semibold text-gray-700 dark:text-gray-300">Type:</h4>
                <p class="text-gray-900 dark:text-gray-100">{{ ucfirst($license->type) }}</p>
            </div>
            <div>
                <h4 class="font-semibold text-gray-700 dark:text-gray-300">Customer:</h4>
                <p class="text-gray-900 dark:text-gray-100">{{ $license->customer_name ?: ($license->customer_email ?: 'N/A') }}</p>
                @if($license->customer_name && $license->customer_email)
                    <p class="text-xs text-gray-500 dark:text-gray-400">{{ $license->customer_email }}</p>
                @endif
            </div>
            @if($license->type === 'codecanyon')
            <div>
                <h4 class="font-semibold text-gray-700 dark:text-gray-300">Purchase Code:</h4>
                <p class="text-gray-900 dark:text-gray-100">{{ $license->purchase_code ?: 'N/A' }}</p>
            </div>
            @if(isset($license->metadata['envato_license_type']))
            <div>
                <h4 class="font-semibold text-gray-700 dark:text-gray-300">Envato License:</h4>
                <p class="text-gray-900 dark:text-gray-100">{{ $license->metadata['envato_license_type'] }}</p>
            </div>
            @endif
            @endif
            <div>
                <h4 class="font-semibold text-gray-700 dark:text-gray-300">Status:</h4>
                <p class="px-2 py-1 inline-block text-xs font-semibold leading-tight
                    @if($license->status == 'active') text-green-700 bg-green-100 dark:bg-green-700 dark:text-green-100
                    @elseif(in_array($license->status, ['pending', 'suspended'])) text-yellow-700 bg-yellow-100 dark:bg-yellow-700 dark:text-yellow-100
                    @else text-red-700 bg-red-100 dark:text-red-100 dark:bg-red-700 @endif
                    rounded-full">
                    {{ ucfirst($license->status) }}
                </p>
            </div>
            <div>
                <h4 class="font-semibold text-gray-700 dark:text-gray-300">Activations:</h4>
                <p class="text-gray-900 dark:text-gray-100">{{ $license->current_activations }} / {{ $license->activation_limit == 0 ? 'Unlimited' : $license->activation_limit }}</p>
            </div>
            <div>
                <h4 class="font-semibold text-gray-700 dark:text-gray-300">Expires At:</h4>
                <p class="text-gray-900 dark:text-gray-100">{{ $license->expires_at ? $license->expires_at->format('M d, Y H:i') : 'Never' }}</p>
            </div>
            <div>
                <h4 class="font-semibold text-gray-700 dark:text-gray-300">Support Until:</h4>
                <p class="text-gray-900 dark:text-gray-100">{{ $license->supported_until ? $license->supported_until->format('M d, Y') : 'N/A' }}</p>
            </div>
        </div>

        @if($license->metadata)
        <div class="mt-4 mb-6">
            <h4 class="font-semibold text-gray-700 dark:text-gray-300">Metadata:</h4>
            <pre class="text-xs bg-gray-100 dark:bg-gray-700 p-3 rounded-md overflow-x-auto"><code class="language-json">{{ json_encode($license->metadata, JSON_PRETTY_PRINT) }}</code></pre>
        </div>
        @endif

            <div class="mt-8 mb-6"> {{-- Adjusted margin and removed unnecessary col-span --}}
                <h3 class="text-lg font-semibold text-gray-700 dark:text-gray-300 mb-3">Activated Domains:</h3>
                @php $activeDomains = $license->getActiveDomains(); @endphp
                @if($activeDomains->isNotEmpty())
                    <ul class="list-disc list-inside text-sm text-gray-600 dark:text-gray-400 mt-1 space-y-1">
                        @foreach($activeDomains as $domain)
                            <li>{{ $domain }}</li>
                        @endforeach
                    </ul>
                @else
                    <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">No domains currently activated with this license.</p>
                @endif
            </div>

        <div class="mt-6">
            <a href="{{ route('admin.appmanager.licenses.edit', $license) }}" class="px-4 py-2 text-sm font-medium leading-5 text-white transition-colors duration-150 bg-purple-600 border border-transparent rounded-lg active:bg-purple-600 hover:bg-purple-700 focus:outline-none focus:shadow-outline-purple">
                Edit License
            </a>
        </div>
    </div>
</div>

<div class="mt-8">
    <h3 class="text-xl font-semibold text-gray-800 dark:text-gray-200 mb-4">Activation Logs</h3>
    <div class="w-full overflow-hidden rounded-lg shadow-xs">
        <div class="w-full overflow-x-auto">
            <table class="w-full whitespace-no-wrap">
                <thead>
                    <tr class="text-xs font-semibold tracking-wide text-left text-gray-500 uppercase border-b dark:border-gray-700 bg-gray-50 dark:text-gray-400 dark:bg-gray-800">
                        <th class="px-4 py-3">Domain</th>
                        <th class="px-4 py-3">IP Address</th>
                        <th class="px-4 py-3">Status</th>
                        <th class="px-4 py-3">Message</th>
                        <th class="px-4 py-3">Date</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y dark:divide-gray-700 dark:bg-gray-800">
                    @forelse ($license->activationLogs as $log)
                    <tr class="text-gray-700 dark:text-gray-400">
                        <td class="px-4 py-3 text-sm">{{ $log->activated_domain ?: '-' }}</td>
                        <td class="px-4 py-3 text-sm">{{ $log->ip_address ?: '-' }}</td>
                        <td class="px-4 py-3 text-xs">
                            <span class="px-2 py-1 font-semibold leading-tight {{ $log->status == 'success' ? 'text-green-700 bg-green-100 dark:bg-green-700 dark:text-green-100' : 'text-red-700 bg-red-100 dark:text-red-100 dark:bg-red-700' }} rounded-full">
                                {{ ucfirst(str_replace('_', ' ', $log->status)) }}
                            </span>
                        </td>
                        <td class="px-4 py-3 text-sm truncate max-w-xs" title="{{ $log->message }}">{{ Str::limit($log->message, 50) ?: '-' }}</td>
                        <td class="px-4 py-3 text-sm">{{ $log->activated_at->format('M d, Y H:i') }}</td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="px-4 py-3 text-center text-sm text-gray-500 dark:text-gray-400">No activation logs found for this license.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
