@extends('layouts.admin')

@section('title', 'Manage Licenses')
@section('header_title', 'Manage Licenses')

@section('content')
<div class="mb-4 flex justify-between items-center">
    <h2 class="text-2xl font-semibold text-gray-700 dark:text-gray-200">Licenses</h2>
    <a href="{{ route('admin.appmanager.licenses.create') }}" class="px-4 py-2 text-sm font-medium leading-5 text-white transition-colors duration-150 bg-purple-600 border border-transparent rounded-lg active:bg-purple-600 hover:bg-purple-700 focus:outline-none focus:shadow-outline-purple">
        Add New License
    </a>
</div>

@include('admin.partials.alerts')

<!-- Search and Filter Form -->
<div class="mb-6 p-4 bg-white dark:bg-gray-800 rounded-lg shadow">
    <form method="GET" action="{{ route('admin.appmanager.licenses.index') }}">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div>
                <label for="search" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Search (Key, Email, Purchase Code, Script Name)</label>
                <input type="text" name="search" id="search" placeholder="Enter search term..." value="{{ request('search') }}"
                       class="mt-1 block w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md focus:border-purple-400 focus:ring focus:ring-purple-200 focus:ring-opacity-50">
            </div>
            <div>
                <label for="managed_script_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Script</label>
                <select name="managed_script_id" id="managed_script_id" class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md">
                    <option value="">All Scripts</option>
                    @foreach($scripts as $id => $name)
                        <option value="{{ $id }}" {{ request('managed_script_id') == $id ? 'selected' : '' }}>{{ $name }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Status</label>
                <select name="status" id="status" class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md">
                    <option value="all" {{ request('status') == 'all' ? 'selected' : '' }}>All Statuses</option>
                     @foreach($statuses as $key => $value)
                        <option value="{{ $key }}" {{ request('status') == $key ? 'selected' : '' }}>{{ $value }}</option>
                    @endforeach
                </select>
            </div>
            <div class="flex items-end">
                <button type="submit" class="px-4 py-2 text-sm font-medium text-white bg-purple-600 rounded-md hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800">
                    Filter
                </button>
                <a href="{{ route('admin.appmanager.licenses.index') }}" class="ml-2 px-4 py-2 text-sm font-medium text-gray-700 dark:text-gray-300 bg-gray-200 dark:bg-gray-600 rounded-md hover:bg-gray-300 dark:hover:bg-gray-500">
                    Clear
                </a>
            </div>
        </div>
    </form>
</div>


<div class="w-full overflow-hidden rounded-lg shadow-xs">
    <div class="w-full overflow-x-auto">
        <table class="w-full whitespace-no-wrap">
            <thead>
                <tr class="text-xs font-semibold tracking-wide text-left text-gray-500 uppercase border-b dark:border-gray-700 bg-gray-50 dark:text-gray-400 dark:bg-gray-800">
                    <th class="px-4 py-3">License Key</th>
                    <th class="px-4 py-3">Script</th>
                    <th class="px-4 py-3">Customer</th>
                    <th class="px-4 py-3">Type</th>
                    <th class="px-4 py-3">Status</th>
                    <th class="px-4 py-3">Activations</th>
                    <th class="px-4 py-3">Expires At</th>
                    <th class="px-4 py-3">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y dark:divide-gray-700 dark:bg-gray-800">
                @forelse ($licenses as $license)
                <tr class="text-gray-700 dark:text-gray-400">
                    <td class="px-4 py-3 text-sm font-semibold" title="{{ $license->license_key }}">{{ Str::limit($license->license_key, 25) }}</td>
                    <td class="px-4 py-3 text-sm">{{ $license->managedScript->name ?? 'N/A' }}</td>
                    <td class="px-4 py-3 text-sm">
                        {{ $license->customer_name ?: ($license->customer_email ?: 'N/A') }}
                        @if($license->customer_name && $license->customer_email)<br><span class="text-xs text-gray-500">{{ $license->customer_email }}</span>@endif
                    </td>
                    <td class="px-4 py-3 text-sm">{{ ucfirst($license->type) }}</td>
                    <td class="px-4 py-3 text-xs">
                        <span class="px-2 py-1 font-semibold leading-tight
                            @if($license->status == 'active') text-green-700 bg-green-100 dark:bg-green-700 dark:text-green-100
                            @elseif(in_array($license->status, ['pending', 'suspended'])) text-yellow-700 bg-yellow-100 dark:bg-yellow-700 dark:text-yellow-100
                            @else text-red-700 bg-red-100 dark:text-red-100 dark:bg-red-700 @endif
                            rounded-full">
                            {{ ucfirst($license->status) }}
                        </span>
                    </td>
                    <td class="px-4 py-3 text-sm">{{ $license->current_activations }} / {{ $license->activation_limit == 0 ? 'Unlimited' : $license->activation_limit }}</td>
                    <td class="px-4 py-3 text-sm">{{ $license->expires_at ? $license->expires_at->format('M d, Y') : 'Never' }}</td>
                    <td class="px-4 py-3">
                        <div class="flex items-center space-x-2 text-sm">
                            <a href="{{ route('admin.appmanager.licenses.show', $license) }}" class="flex items-center justify-between px-2 py-2 text-sm font-medium leading-5 text-purple-600 rounded-lg dark:text-gray-400 focus:outline-none focus:shadow-outline-gray" aria-label="View">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path></svg>
                            </a>
                            <a href="{{ route('admin.appmanager.licenses.edit', $license) }}" class="flex items-center justify-between px-2 py-2 text-sm font-medium leading-5 text-purple-600 rounded-lg dark:text-gray-400 focus:outline-none focus:shadow-outline-gray" aria-label="Edit">
                                <svg class="w-5 h-5" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20"><path d="M13.586 3.586a2 2 0 112.828 2.828l-.793.793-2.828-2.828.793-.793zM11.379 5.793L3 14.172V17h2.828l8.38-8.379-2.83-2.828z"></path></svg>
                            </a>
                            <form action="{{ route('admin.appmanager.licenses.destroy', $license) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this license?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="flex items-center justify-between px-2 py-2 text-sm font-medium leading-5 text-purple-600 rounded-lg dark:text-gray-400 focus:outline-none focus:shadow-outline-gray" aria-label="Delete">
                                    <svg class="w-5 h-5" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm5-1a1 1 0 00-1 1v6a1 1 0 102 0V8a1 1 0 00-1-1z" clip-rule="evenodd"></path></svg>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="8" class="px-4 py-3 text-center text-sm text-gray-500 dark:text-gray-400">No licenses found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    <div class="px-4 py-3">
        {{ $licenses->links() }}
    </div>
</div>
@endsection
