@extends('layouts.admin')

@section('title', 'Script Details: ' . $script->name)
@section('header_title', 'Script Details: ' . $script->name)

@section('content')
<div class="mb-4">
    <a href="{{ route('admin.appmanager.scripts.index') }}" class="text-purple-600 hover:text-purple-800 dark:text-purple-400 dark:hover:text-purple-200">&larr; Back to Scripts</a>
</div>

<div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
    <div class="p-6 lg:p-8">
        <h3 class="text-xl font-semibold text-gray-800 dark:text-gray-200 mb-2">{{ $script->name }} <span class="text-sm text-gray-500 dark:text-gray-400">(v{{ $script->current_version }})</span></h3>
        <p class="text-sm text-gray-600 dark:text-gray-400 mb-1">Slug: {{ $script->slug }}</p>
        <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">Status: <span class="font-medium">{{ ucfirst($script->status) }}</span></p>

        @if($script->description)
        <div class="mt-4">
            <h4 class="font-semibold text-gray-700 dark:text-gray-300">Description:</h4>
            <div class="prose dark:prose-invert max-w-none text-sm text-gray-600 dark:text-gray-400">
                {!! nl2br(e($script->description)) !!}
            </div>
        </div>
        @endif

        @if($script->changelog)
        <div class="mt-6">
            <h4 class="font-semibold text-gray-700 dark:text-gray-300">Changelog:</h4>
            <div class="prose dark:prose-invert max-w-none text-sm text-gray-600 dark:text-gray-400 p-4 border rounded-md dark:border-gray-700 mt-2 bg-gray-50 dark:bg-gray-700/50 max-h-96 overflow-y-auto">
                {!! nl2br(e($script->changelog)) !!} {{-- Consider Markdown parsing here --}}
            </div>
        </div>
        @endif

        <div class="mt-6 flex space-x-3">
            <a href="{{ route('admin.appmanager.scripts.edit', $script) }}" class="px-4 py-2 text-sm font-medium leading-5 text-white transition-colors duration-150 bg-purple-600 border border-transparent rounded-lg active:bg-purple-600 hover:bg-purple-700 focus:outline-none focus:shadow-outline-purple">
                Edit Script
            </a>
            <a href="{{ route('admin.appmanager.scripts.files.index', $script) }}" class="px-4 py-2 text-sm font-medium leading-5 text-white transition-colors duration-150 bg-blue-500 border border-transparent rounded-lg active:bg-blue-600 hover:bg-blue-700 focus:outline-none focus:shadow-outline-blue">
                Manage Downloadable Files ({{ $script->downloadableFiles()->count() }})
            </a>
             <a href="{{ route('admin.appmanager.licenses.index', ['managed_script_id' => $script->id]) }}" class="px-4 py-2 text-sm font-medium leading-5 text-white transition-colors duration-150 bg-green-500 border border-transparent rounded-lg active:bg-green-600 hover:bg-green-700 focus:outline-none focus:shadow-outline-green">
                View Licenses ({{ $script->licenses()->count() }})
            </a>
        </div>
    </div>
</div>
@endsection
