<div class="grid grid-cols-1 md:grid-cols-2 gap-6">
    <div>
        <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Script Name <span class="text-red-500">*</span></label>
        <input type="text" name="name" id="name" value="{{ old('name', $script->name ?? '') }}" required
               class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
        @error('name') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="slug" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Slug (URL friendly)</label>
        <input type="text" name="slug" id="slug" value="{{ old('slug', $script->slug ?? '') }}"
               placeholder="Leave blank to auto-generate from name"
               class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
        @error('slug') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="current_version" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Current Version <span class="text-red-500">*</span></label>
        <input type="text" name="current_version" id="current_version" value="{{ old('current_version', $script->current_version ?? '1.0.0') }}" required
               class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
        @error('current_version') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Status <span class="text-red-500">*</span></label>
        <select name="status" id="status" required
                class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md">
            @foreach($statuses as $key => $value)
                <option value="{{ $key }}" {{ old('status', $script->status ?? 'development') == $key ? 'selected' : '' }}>{{ $value }}</option>
            @endforeach
        </select>
        @error('status') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div class="md:col-span-2">
        <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Description</label>
        <textarea name="description" id="description" rows="4"
                  class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">{{ old('description', $script->description ?? '') }}</textarea>
        @error('description') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div class="md:col-span-2">
        <label for="changelog" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Changelog (Markdown supported)</label>
        <textarea name="changelog" id="changelog" rows="6"
                  class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">{{ old('changelog', $script->changelog ?? '') }}</textarea>
        @error('changelog') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="is_boilerplate_core" class="flex items-center cursor-pointer mt-1">
            <div class="relative">
                <input type="checkbox" id="is_boilerplate_core" name="is_boilerplate_core" class="sr-only" value="1" {{ old('is_boilerplate_core', isset($script) && $script->is_boilerplate_core ? '1' : '0') == '1' ? 'checked' : '' }}>
                <div class="block bg-gray-600 dark:bg-gray-700 w-14 h-8 rounded-full"></div>
                <div class="dot absolute left-1 top-1 bg-white w-6 h-6 rounded-full transition"></div>
            </div>
            <div class="ml-3 text-gray-700 dark:text-gray-300 font-medium">
                Is Boilerplate Core License?
            </div>
        </label>
        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Check if this script represents the main boilerplate application itself.</p>
        @error('is_boilerplate_core') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>
</div>

<div class="mt-8 flex justify-end">
    <a href="{{ route('admin.appmanager.scripts.index') }}" class="mr-3 inline-flex items-center px-4 py-2 bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-500 rounded-md font-semibold text-xs text-gray-700 dark:text-gray-300 uppercase tracking-widest shadow-sm hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 disabled:opacity-25 transition ease-in-out duration-150">
        Cancel
    </a>
    <button type="submit" class="inline-flex items-center px-4 py-2 bg-purple-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-purple-700 active:bg-purple-900 focus:outline-none focus:border-purple-900 focus:ring ring-purple-300 disabled:opacity-25 transition ease-in-out duration-150">
        {{ isset($script) ? 'Update Script' : 'Create Script' }}
    </button>
</div>

<style> /* Re-add toggle styles if not globally available in admin layout */
    input:checked ~ .dot { transform: translateX(100%); background-color: #48bb78; }
    input:checked ~ .block { background-color: #a0aec0; }
    .dark input:checked ~ .dot { background-color: #38a169; }
    .dark input:checked ~ .block { background-color: #4a5568; }
</style>
