<?php

namespace Modules\AppManager\Database\factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Modules\AppManager\Entities\License;

class DownloadTokenFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = \Modules\AppManager\Entities\DownloadToken::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'license_id' => License::factory(), // Assumes LicenseFactory exists
            'token' => Str::random(60),
            'ip_address' => $this->faker->ipv4,
            'user_agent' => $this->faker->userAgent,
            'uses' => 0,
            'max_uses' => $this->faker->numberBetween(1, 5),
            'expires_at' => now()->addHours($this->faker->numberBetween(1, 24)),
        ];
    }
}