<?php

return [
    'name' => 'AppManager',

    /*
    |--------------------------------------------------------------------------
    | Storage Disk for Downloadable Files
    |--------------------------------------------------------------------------
    |
    | Specify the Laravel filesystem disk where downloadable files managed by
    | AppManager will be stored. 'local' is recommended for security,
    | as files will not be publicly accessible via a URL.
    |
    */
    'storage_disk' => env('APPMANAGER_STORAGE_DISK', 'local'),

    /*
    |--------------------------------------------------------------------------
    | Envato API Configuration
    |--------------------------------------------------------------------------
    |
    | Settings for integrating with the Envato API to verify purchase codes.
    |
    */
    'envato_personal_token' => env('ENVATO_PERSONAL_TOKEN', null),
    // You might map product slugs to Envato Item IDs here or in the database
    // 'envato_item_ids' => [
    //     'your-script-slug' => 12345678, // Example Envato Item ID
    // ],

    /*
    |--------------------------------------------------------------------------
    | Download Token Configuration
    |--------------------------------------------------------------------------
    */
    'download_token_ttl_minutes' => env('APPMANAGER_DOWNLOAD_TOKEN_TTL', 30), // Time-to-live in minutes
    'download_token_max_uses' => env('APPMANAGER_DOWNLOAD_TOKEN_MAX_USES', 5), // Max uses per token (e.g., for a set of files)
];