<?php

namespace Modules\AppManager\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    protected string $name = 'AppManager';
    /**
     * The module namespace to assume when generating URLs to actions.
     */
    protected string $moduleNamespace = 'Modules\AppManager\Http\Controllers';

    /**
     * Called before routes are registered.
     *
     * Register any model bindings or pattern based filters.
     */
    public function boot(): void
    {
        parent::boot();
    }

    /**
     * Define the routes for the application.
     */
    public function map(): void
    {
        $this->mapAdminRoutes();
        $this->mapApiRoutes();
        $this->mapWebRoutes();
    }

    /**
     * Define the "admin" routes for the module.
     *
     * These routes are typically protected by admin-specific middleware.
     * They are prefixed with '/admin/appmanager' and named with 'admin.appmanager.'.
     */
    protected function mapAdminRoutes(): void
    {
        Route::middleware(['web', \App\Http\Middleware\IsAdminMiddleware::class])
             ->prefix('admin/' . strtolower($this->name)) // e.g., admin/appmanager
             ->name('admin.' . strtolower($this->name) . '.')     // e.g., admin.appmanager.
             // If your admin controllers are in an 'Admin' sub-namespace and not fully namespaced in routes/admin.php:
             // ->namespace($this->moduleNamespace . '\\Admin')
             ->group(module_path($this->name, '/routes/admin.php'));
    }

    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     */
    protected function mapWebRoutes(): void
    {
        Route::middleware('web')->group(module_path($this->name, '/routes/web.php'));
    }

    /**
     * Define the "api" routes for the application.
     *
     * These routes are typically stateless.
     */
    protected function mapApiRoutes(): void
    {
        Route::middleware('api')
            ->prefix('api') // Global API prefix, module-specific path defined in routes/api.php
            ->name('api.')   // Global API route name prefix
            // If your API controllers are in an 'Api' sub-namespace and not fully namespaced in routes/api.php:
            // ->namespace($this->moduleNamespace . '\\Api')
            ->group(module_path($this->name, '/routes/api.php'));
    }
}
