<?php

namespace Modules\AppManager\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Str;

class ManagedScript extends Model
{
    use HasFactory;

    protected $table = 'am_managed_scripts';

    protected $fillable = [
        'name',
        'slug',
        'current_version',
        'description',
        'changelog',
        'is_boilerplate_core',
        'status',
        'envato_item_id', // Add this
    ];

    protected $casts = [
        'is_boilerplate_core' => 'boolean',
    ];

    protected static function newFactory()
    {
        // return \Modules\AppManager\Database\factories\ManagedScriptFactory::new();
    }

    public function downloadableFiles(): HasMany
    {
        return $this->hasMany(DownloadableFile::class);
    }

    public function licenses(): HasMany
    {
        return $this->hasMany(License::class);
    }

    protected static function booted()
    {
        static::creating(function ($script) {
            if (empty($script->slug)) {
                $script->slug = Str::slug($script->name);
            }
        });
    }
}