<?php

namespace Modules\AppManager\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DownloadableFile extends Model
{
    use HasFactory;

    protected $table = 'am_downloadable_files';

    protected $fillable = [
        'managed_script_id',
        'file_name',
        'file_path',
        'version',
        'target_path',
        'file_hash',
        'description',
        'is_critical',
    ];

    protected static function newFactory()
    {
        // return \Modules\AppManager\Database\factories\DownloadableFileFactory::new();
    }

    public function managedScript(): BelongsTo
    {
        return $this->belongsTo(ManagedScript::class);
    }
}