<?php

namespace Modules\AppManager\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ActivationLog extends Model
{
    use HasFactory;

    protected $table = 'am_activation_logs';

    public $timestamps = false; // We only have 'activated_at'

    protected $fillable = [
        'license_id',
        'managed_script_id', // Added: To link directly to the script being activated
        'activated_domain',
        'ip_address',
        'server_signature',
        'status',
        'message',
        'activated_at',
        'license_key_attempt', // Added: To log the license key that was attempted
        'purchase_code_attempt', // Added: To log the purchase code that was attempted
    ];

    protected $casts = [
        'activated_at' => 'datetime',
    ];

    public function license(): BelongsTo
    {
        return $this->belongsTo(License::class);
    }

    /**
     * Get the managed script associated with the activation log.
     */
    public function managedScript(): BelongsTo
    {
        return $this->belongsTo(ManagedScript::class);
    }
}