<?php

use Illuminate\Support\Facades\Route;
use Modules\WebPilotAI\Http\Controllers\User\WebsiteController;
// Assuming you will create these controllers in Modules/WebPilotAI/Http/Controllers/User/
use Modules\WebPilotAI\Http\Controllers\User\TemplateController;
use Modules\WebPilotAI\Http\Controllers\User\ContentWriterController;
use Modules\WebPilotAI\Http\Controllers\User\ImageStudioController;


Route::group(['middleware' => ['auth', 'verified'], 'as' => 'frontend.webpilotai.'], function () { // Assuming user routes require authentication
    // User Websites CRUD
    Route::resource('websites', WebsiteController::class)->names([
        'index' => 'websites.index',
        'create' => 'websites.create',
        'store' => 'websites.store',
        'show' => 'websites.show',
        'edit' => 'websites.edit',
        'update' => 'websites.update',
        'destroy' => 'websites.destroy',
    ]);

    // Deployment Routes
    Route::get('websites/{website}/deploy', [WebsiteController::class, 'showDeployForm'])->name('websites.deploy.form');
    Route::post('websites/{website}/deploy', [WebsiteController::class, 'deploy'])->name('websites.deploy.submit');
    Route::get('websites/{website}/status', [WebsiteController::class, 'checkStatus'])->name('websites.status'); // For AJAX status checks
    Route::post('websites/{website}/regenerate', [WebsiteController::class, 'regenerate'])->name('websites.regenerate'); // New route for regeneration

    // AI Template Library
    Route::get('templates', [TemplateController::class, 'index'])->name('templates.index');

    // AI Content Writer
    Route::get('content-writer', [ContentWriterController::class, 'index'])->name('contentwriter.index');
    Route::post('content-writer/generate', [ContentWriterController::class, 'generate'])->name('contentwriter.generate');

    // AI Image Studio
    Route::get('image-studio', [ImageStudioController::class, 'index'])->name('imagestudio.index');
    Route::post('image-studio/generate-ai', [ImageStudioController::class, 'generateImage'])->name('imagestudio.generate');
    Route::post('image-studio/search-stock', [ImageStudioController::class, 'searchStockPhotos'])->name('imagestudio.searchstock');
});