@component('mail::message')
# Uh Oh! Problem Deploying Your AI Website

Hello {{ $website->user->name ?? 'User' }},

We encountered an issue while trying to deploy your website, **"{{ $website->name ?: 'Untitled Website' }}"**.

**Deployment Target:**
- **Type:** {{ strtoupper($website->deployment_details['type'] ?? ($website->deploymentConfig['deployment_type'] ?? 'N/A')) }}
- **Host:** {{ $website->deployment_details['host'] ?? ($website->deploymentConfig['host'] ?? 'N/A') }}

**Error Details:**
```
{{ $errorMessage }}
```

Please check your deployment settings and try again.

@component('mail::button', ['url' => route('frontend.webpilotai.websites.deploy.form', $website->id)])
Retry Deployment
@endcomponent

If the problem persists, please contact support.

Thanks,<br>
{{ config('app.name') }}
@endcomponent