@extends('layouts.admin') {{-- Or your main user-facing layout --}}

@section('title', 'Website Details: ' . ($website->name ?: 'Untitled Website'))
@section('header_title', $website->name ?: 'Untitled Website') {{-- Or your layout's equivalent section --}}

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="max-w-4xl mx-auto bg-white dark:bg-gray-800 shadow-xl rounded-lg">
        <div class="p-6 md:p-8">
            <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6">
                <h1 class="text-3xl font-bold text-gray-800 dark:text-white mb-3 md:mb-0">
                    {{ $website->name ?: 'Untitled Website' }}
                </h1>
                <div class="flex space-x-3">
                    <a href="{{ route('frontend.webpilotai.websites.edit', $website->id) }}" class="inline-flex items-center px-4 py-2 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                        <i class="fas fa-edit mr-2"></i>Edit
                    </a>
                    @if($website->status === \Modules\WebPilotAI\Models\Website::STATUS_COMPLETED && $website->generated_content_path)
                        <a href="{{ asset($website->generated_content_path) }}" download class="inline-flex items-center px-4 py-2 border border-green-500 shadow-sm text-sm font-medium rounded-md text-green-700 bg-green-100 hover:bg-green-200 dark:text-green-300 dark:bg-green-700 dark:hover:bg-green-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                            <i class="fas fa-download mr-2"></i>Download ZIP
                        </a>
                    @endif
                </div>
            </div>

            @include('webpilotai::admin.partials._session_messages')

            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                <div class="md:col-span-2 space-y-4">
                    <div>
                        <h2 class="text-sm font-medium text-gray-500 dark:text-gray-400">Status</h2>
                        <p class="mt-1 text-lg text-gray-900 dark:text-white">
                            <span class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full
                                @if($website->status === \Modules\WebPilotAI\Models\Website::STATUS_COMPLETED) bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100
                                @elseif(in_array($website->status, [\Modules\WebPilotAI\Models\Website::STATUS_PENDING_GENERATION, \Modules\WebPilotAI\Models\Website::STATUS_GENERATING, \Modules\WebPilotAI\Models\Website::STATUS_PENDING_REGENERATION])) bg-yellow-100 text-yellow-800 dark:bg-yellow-700 dark:text-yellow-100
                                @elseif($website->status === \Modules\WebPilotAI\Models\Website::STATUS_FAILED) bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100
                                @else bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-200 @endif">
                                {{ Str::title(str_replace('_', ' ', $website->status)) }}
                            </span>
                        </p>
                    </div>
                     <div>
                        <h2 class="text-sm font-medium text-gray-500 dark:text-gray-400">AI Model Used</h2>
                        <p class="mt-1 text-md text-gray-900 dark:text-white">{{ $website->aiModel->name ?? 'N/A' }} ({{ $website->aiModel->provider ?? 'N/A' }})</p>
                    </div>
                    <div>
                        <h2 class="text-sm font-medium text-gray-500 dark:text-gray-400">AI Template Used</h2>
                        <p class="mt-1 text-md text-gray-900 dark:text-white">{{ $website->aiTemplate->name ?? 'None Selected' }}</p>
                    </div>
                    <div>
                        <h2 class="text-sm font-medium text-gray-500 dark:text-gray-400">AI Style Presets Used</h2>
                        <div class="mt-1">
                            @forelse($website->aiStylePresets as $preset)
                                <span class="inline-block bg-gray-200 dark:bg-gray-700 rounded-full px-3 py-1 text-xs font-semibold text-gray-700 dark:text-gray-200 mr-2 mb-2">{{ $preset->name }}</span>
                            @empty
                                <span class="text-sm text-gray-900 dark:text-white">None Selected</span>
                            @endforelse
                        </div>
                    </div>
                </div>
                <div class="space-y-4">
                    <div>
                        <h2 class="text-sm font-medium text-gray-500 dark:text-gray-400">Created</h2>
                        <p class="mt-1 text-md text-gray-900 dark:text-white">{{ $website->created_at->format('M d, Y H:i A') }}</p>
                    </div>
                    <div>
                        <h2 class="text-sm font-medium text-gray-500 dark:text-gray-400">Last Generated</h2>
                        <p class="mt-1 text-md text-gray-900 dark:text-white">{{ $website->last_generated_at ? $website->last_generated_at->format('M d, Y H:i A') : 'Never' }}</p>
                    </div>
                </div>
            </div>

            @if($website->status === \Modules\WebPilotAI\Models\Website::STATUS_FAILED && $website->generation_error)
            <div class="mb-8">
                <h3 class="text-lg font-medium text-red-600 dark:text-red-400 mb-1">Last Generation Error</h3>
                <div class="p-4 bg-red-50 dark:bg-red-900 border border-red-200 dark:border-red-700 rounded-md text-sm text-red-700 dark:text-red-200 whitespace-pre-wrap">
                    {{ $website->generation_error }}
                </div>
            </div>
            @endif

            <div class="mb-8">
                <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-2">Description Prompt</h3>
                <div class="p-4 bg-gray-50 dark:bg-gray-700 rounded-md text-sm text-gray-700 dark:text-gray-300 whitespace-pre-wrap leading-relaxed">
                    {{ $website->description_prompt }}
                </div>
            </div>

            @if($website->status === \Modules\WebPilotAI\Models\Website::STATUS_COMPLETED && $website->generated_content_path)
                <div class="mb-8 p-4 border-t border-b border-gray-200 dark:border-gray-700">
                    <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-2">Website Ready!</h3>
                    <p class="text-sm text-gray-600 dark:text-gray-300 mb-3">Your website has been generated. Download the ZIP file to host it or make further manual edits.</p>
                    <a href="{{ asset($website->generated_content_path) }}" download class="inline-flex items-center px-6 py-3 border border-transparent shadow-sm text-base font-medium rounded-md text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                        <i class="fas fa-cloud-download-alt mr-2"></i> Download Website ZIP
                    </a>
                    <p class="mt-3 text-xs text-gray-500 dark:text-gray-400">
                        To preview, download the ZIP, extract it, and open the <code>index.html</code> file in your browser.
                    </p>
                </div>
            @elseif(in_array($website->status, [\Modules\WebPilotAI\Models\Website::STATUS_PENDING_GENERATION, \Modules\WebPilotAI\Models\Website::STATUS_GENERATING, \Modules\WebPilotAI\Models\Website::STATUS_PENDING_REGENERATION]))
                <div class="mb-8 p-4 bg-yellow-50 dark:bg-yellow-900 border-l-4 border-yellow-400 dark:border-yellow-600">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-yellow-400 dark:text-yellow-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                                <path fill-rule="evenodd" d="M8.485 2.495c.673-1.167 2.357-1.167 3.03 0l6.28 10.875c.673 1.167-.17 2.625-1.516 2.625H3.72c-1.347 0-2.189-1.458-1.515-2.625L8.485 2.495zM10 5a.75.75 0 01.75.75v3.5a.75.75 0 01-1.5 0v-3.5A.75.75 0 0110 5zm0 9a1 1 0 100-2 1 1 0 000 2z" clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm text-yellow-700 dark:text-yellow-200">
                                Your website is currently <strong>{{ Str::lower(str_replace('_', ' ', $website->status)) }}</strong>. Please check back shortly.
                                {{-- Consider adding auto-refresh JS if status is 'generating' --}}
                            </p>
                        </div>
                    </div>
                </div>
            @endif

            <div class="mt-8 pt-6 border-t border-gray-200 dark:border-gray-700">
                <a href="{{ route('frontend.webpilotai.websites.index') }}" class="text-indigo-600 hover:text-indigo-800 dark:text-indigo-400 dark:hover:text-indigo-300 font-medium">
                    &larr; Back to My Websites
                </a>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
@if(in_array($website->status, [\Modules\WebPilotAI\Models\Website::STATUS_GENERATING, \Modules\WebPilotAI\Models\Website::STATUS_PENDING_REGENERATION, \Modules\WebPilotAI\Models\Website::STATUS_DEPLOYING]))
<script>
    // Optional: Auto-refresh the page if the status is 'generating', 'pending_regeneration', or 'deploying'
    // This is a simple refresh. For a better UX, consider AJAX polling to update only parts of the page.
    // setTimeout(function(){
    //    window.location.reload(1);
    // }, 15000); // Refresh every 15 seconds

    // More advanced AJAX polling (example)
    // function checkStatus() {
    //     fetch("{{ route('frontend.webpilotai.websites.status', $website->id) }}") // You'd need a status check route
    //         .then(response => response.json())
    //         .then(data => {
    //             if (data.status !== '{{ $website->status }}') {
    //                 window.location.reload();
    //             } else if (['generating', 'pending_regeneration', 'deploying'].includes(data.status)) {
    //                 setTimeout(checkStatus, 15000);
    //             }
    //         });
    // }
    // if (['generating', 'pending_regeneration', 'deploying'].includes('{{ $website->status }}')) {
    //     setTimeout(checkStatus, 15000);
    // }
</script>
@endif
@endpush
