@extends('layouts.admin') {{-- Or your main admin layout --}}

@section('title', 'Edit User Website: ' . ($website->name ?: 'Untitled Website'))
@section('header_title', 'Edit User Website: ' . ($website->name ?: 'Untitled Website'))

@section('content')
<div class="p-6">
    <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg p-6">
        <h2 class="text-2xl font-semibold text-gray-700 dark:text-gray-200 mb-6">Update Website Details (Admin)</h2>

        @include('webpilotai::admin.partials._validation_errors')
        @include('webpilotai::admin.partials._session_messages')

        <form action="{{ route('admin.webpilotai.user-sites.update', $website->id) }}" method="POST">
            @csrf
            @method('PUT')

            {{-- Website Name --}}
            <div class="mb-6">
                <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Website Name (Optional)</label>
                <input type="text" id="name" name="name" value="{{ old('name', $website->name) }}"
                       class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm dark:text-gray-200">
            </div>

            {{-- Description Prompt --}}
            <div class="mb-6">
                <label for="description_prompt" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Description Prompt <span class="text-red-500">*</span></label>
                <textarea name="description_prompt" id="description_prompt" rows="8" required
                          class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm dark:text-gray-200">{{ old('description_prompt', $website->description_prompt) }}</textarea>
            </div>

            {{-- AI Template Selection --}}
            <div class="mb-6 p-4 border border-gray-200 dark:border-gray-700 rounded-lg">
                <label class="block text-lg font-semibold text-gray-700 dark:text-gray-300 mb-3">Choose an AI Template (Optional)</label>
                @if($aiTemplates->isEmpty())
                    <p class="text-gray-500 dark:text-gray-400">No AI templates are currently available.</p>
                @else
                    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4 template-selection-container-admin">
                        <label class="template-card-admin p-4 border rounded-lg cursor-pointer hover:border-indigo-500 dark:border-gray-600 dark:hover:border-indigo-400 transition-colors">
                            <input type="radio" name="ai_template_id" value="" {{ old('ai_template_id', $website->ai_template_id) == '' ? 'checked' : '' }} class="mr-2">
                            <strong class="block text-md font-medium text-gray-800 dark:text-gray-100 mb-1">No Specific Template</strong>
                            <p class="text-xs text-gray-600 dark:text-gray-400">Use default AI behavior.</p>
                        </label>
                        @foreach($aiTemplates as $template)
                        <label class="template-card-admin p-4 border rounded-lg cursor-pointer hover:border-indigo-500 dark:border-gray-600 dark:hover:border-indigo-400 transition-colors">
                            <input type="radio" name="ai_template_id" value="{{ $template->id }}" {{ old('ai_template_id', $website->ai_template_id) == $template->id ? 'checked' : '' }} class="mr-2">
                            @if($template->preview_image_path)
                                <img src="{{ asset('storage/' . $template->preview_image_path) }}" alt="{{ $template->name }} preview" class="w-full h-24 object-cover rounded mb-2 border dark:border-gray-600">
                            @else
                                <div class="w-full h-24 flex items-center justify-center bg-gray-100 dark:bg-gray-700 text-gray-400 dark:text-gray-500 rounded mb-2 text-xs">No Preview</div>
                            @endif
                            <strong class="block text-md font-medium text-gray-800 dark:text-gray-100 mb-1">
                                {{ $template->name }}
                                @if($template->is_premium)<span class="text-xs text-yellow-500 ml-1">[Premium]</span>@endif
                            </strong>
                            <p class="text-xs text-gray-600 dark:text-gray-400 truncate" title="{{ $template->description }}">{{ Str::limit($template->description, 50) }}</p>
                        </label>
                        @endforeach
                    </div>
                    <small class="block mt-2 text-xs text-gray-500 dark:text-gray-400">This will be applied if you choose to re-generate.</small>
                @endif
            </div>

            {{-- AI Style Presets Selection --}}
            <div class="mb-6 p-4 border border-gray-200 dark:border-gray-700 rounded-lg">
                <label class="block text-lg font-semibold text-gray-700 dark:text-gray-300 mb-3">Choose AI Style Presets (Optional)</label>
                @if($aiStylePresets->isEmpty())
                    <p class="text-gray-500 dark:text-gray-400">No AI style presets are currently available.</p>
                @else
                    @php
                        $groupedStylePresets = $aiStylePresets->groupBy('type');
                        $currentPresetIds = old('ai_style_preset_ids', $website->aiStylePresets->pluck('id')->toArray());
                    @endphp
                    @foreach($groupedStylePresets as $type => $presets)
                        <fieldset class="mb-4">
                            <legend class="text-md font-semibold text-gray-700 dark:text-gray-300 mb-2">{{ Str::title(str_replace('_', ' ', $type)) }}</legend>
                            <div class="space-y-2">
                                @foreach($presets as $preset)
                                <label for="ai_style_preset_{{ $preset->id }}" class="flex items-center text-sm text-gray-700 dark:text-gray-300">
                                    <input type="checkbox" name="ai_style_preset_ids[]" id="ai_style_preset_{{ $preset->id }}" value="{{ $preset->id }}"
                                           {{ (is_array($currentPresetIds) && in_array($preset->id, $currentPresetIds)) ? 'checked' : '' }}
                                           class="h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 rounded focus:ring-indigo-500 mr-2">
                                    <span title="{{ $preset->description }}">{{ $preset->name }}</span>
                                    @if($preset->is_premium)<span class="text-xs text-yellow-500 ml-1">[Premium]</span>@endif
                                    @if($preset->preview_image_path)
                                        <img src="{{ asset('storage/' . $preset->preview_image_path) }}" alt="{{ $preset->name }} preview" class="h-5 w-8 object-cover ml-2 border dark:border-gray-600 rounded-sm">
                                    @endif
                                </label>
                                @endforeach
                            </div>
                        </fieldset>
                    @endforeach
                    <small class="block mt-2 text-xs text-gray-500 dark:text-gray-400">Changes will be applied if you choose to re-generate.</small>
                @endif
            </div>

            {{-- AI Model Selection --}}
            <div class="mb-6">
                <label for="ai_model_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">AI Generation Model <span class="text-red-500">*</span></label>
                @if($aiModels->isEmpty())
                    <p class="text-orange-500">No AI models are currently available. Please configure them in settings.</p>
                @else
                    <select name="ai_model_id" id="ai_model_id" required
                            class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm dark:text-gray-200">
                        @foreach($aiModels as $model)
                            <option value="{{ $model->id }}" {{ old('ai_model_id', $website->ai_model_id) == $model->id ? 'selected' : '' }}>
                                {{ $model->name }} ({{ $model->provider }}) {{ $model->is_premium ? '[Premium]' : '' }}
                            </option>
                        @endforeach
                    </select>
                @endif
            </div>

            {{-- Re-generate Option --}}
            <div class="mb-6">
                <label for="regenerate" class="flex items-center">
                    <input type="checkbox" id="regenerate" name="regenerate" value="1" {{ old('regenerate') ? 'checked' : '' }}
                           class="h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 rounded focus:ring-indigo-500 mr-2">
                    <span class="text-sm text-gray-700 dark:text-gray-300">Re-generate website content with these new details</span>
                </label>
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">If checked, the existing generated site will be replaced. If unchecked, only the associations will be updated.</p>
            </div>

            {{-- Actions --}}
            <div class="mt-8 pt-5 border-t border-gray-200 dark:border-gray-700">
                <div class="flex justify-end">
                    <a href="{{ route('admin.webpilotai.user-sites.show', $website->id) }}" class="bg-gray-200 hover:bg-gray-300 text-gray-700 font-bold py-2 px-4 rounded-lg mr-3 transition duration-150 ease-in-out dark:bg-gray-600 dark:text-gray-200 dark:hover:bg-gray-500">
                        Cancel
                    </a>
                    <button type="submit" class="bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-4 rounded-lg shadow-md transition duration-150 ease-in-out" {{ $aiModels->isEmpty() ? 'disabled' : '' }}>
                        <i class="fas fa-save mr-2"></i> Update Website
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@push('styles')
<style>
    .template-card-admin input[type="radio"]:checked + img + strong,
    .template-card-admin input[type="radio"]:checked + div + strong, /* For No Preview */
    .template-card-admin input[type="radio"]:checked + strong /* For No Specific Template */ {
        color: #4f46e5; /* indigo-600 */
    }
    .template-card-admin input[type="radio"]:checked {
        /* You might want to hide the radio button itself and style the label */
    }
    .template-card-admin {
        /* Add styles to indicate selection, e.g., border color */
    }
    .template-card-admin:has(input[type="radio"]:checked) {
        border-color: #4f46e5; /* indigo-600 */
        box-shadow: 0 0 0 2px rgba(79, 70, 229, .5);
    }
</style>
@endpush