# WebPilot AI Module

## Description

WebPilot AI is an innovative module that empowers users to create websites using Artificial Intelligence. Users provide prompts about their desired website, and WebPilot AI assists in generating design layouts, initial content, and a responsive structure. The created websites can then be downloaded as static files, deployed directly to cPanel hosting, or pushed to a GitHub repository.

## Core Features

*   **AI-Powered Website Scoping:** Users define their website needs through guided prompts (industry, purpose, style, content ideas, target audience, brand elements).
*   **Intelligent Design Generation:** AI suggests layouts, visual themes (color palettes, typography), and sitemap structures.
*   **Automated Content Scaffolding:** AI generates initial draft text for key pages (Home, About, Services, Contact) and suggests relevant image types or royalty-free image sources.
*   **SEO Assistance:** AI helps create basic meta titles, descriptions, and image alt text.
*   **Simplified In-App Editor:**
    *   Modify generated text directly on a live preview.
    *   Replace placeholder images.
    *   Manage (add, remove, reorder) predefined page sections.
    *   Basic style customization (e.g., primary colors, fonts from a curated list).
*   **Responsive Output:** All generated websites are designed to be mobile-friendly and adapt to various screen sizes.
*   **Multiple Deployment Options:**
    *   Download website as a static HTML/CSS/JS ZIP archive.
    *   Direct deployment to cPanel hosting (requires user credentials or API access).
    *   Push to a GitHub repository (ideal for GitHub Pages or other static hosting services).
*   **User Project Dashboard:** Manage all created website projects, access the editor, preview sites, and manage deployment statuses.
*   **AI Model Integration:** Leverages advanced LLMs (e.g., OpenAI's GPT, Google's Gemini) for design, content, and structural suggestions, requiring API key configuration.

## Installation & Setup

1.  Ensure the module is enabled in your main application's module configuration.
2.  Run migrations: `php artisan module:migrate WebPilotAI`
3.  **Admin Panel Setup:**
    *   Navigate to WebPilot AI -> Settings.
    *   Configure API keys for the chosen AI model provider (e.g., OpenAI, Gemini).
    *   Review and configure settings related to cPanel and GitHub integration (e.g., security protocols, API usage limits if applicable, recommended best practices for credential handling).

## Workflow

1.  **Start a New Website:** From the WebPilot AI dashboard, initiate a new website project.
2.  **Provide Website Brief:** Answer a series of guided questions to describe the website you want to create (e.g., type of business, target audience, key pages, desired look and feel, any existing brand assets).
3.  **AI Generation:** WebPilot AI processes your brief and generates:
    *   Layout suggestions and a sitemap.
    *   A visual theme (colors, fonts).
    *   Draft content for main pages.
4.  **Customize & Refine:**
    *   Use the in-app editor to modify text, swap images, and adjust section layouts.
    *   Provide further prompts to the AI for revisions if needed.
5.  **Preview:** Review the website on different screen sizes to ensure responsiveness.
6.  **Deploy/Download:**
    *   Download the website as a ZIP file for manual hosting.
    *   Connect your cPanel account to deploy directly.
    *   Connect your GitHub account to push the site to a repository.

## Important Considerations

*   **AI as an Assistant:** The websites generated by AI serve as a strong starting point. Further customization and content refinement by the user are typically expected for a polished final product.
*   **Content Originality:** While AI can generate text, users should review and personalize it to ensure uniqueness, accuracy, and alignment with their brand voice.
*   **Image Sourcing:** Users are responsible for ensuring they have the rights to use any images on their website. The AI may suggest image types, but sourcing and licensing are typically user responsibilities.
*   **Security for Deployment:** Emphasize secure management of cPanel and GitHub credentials. OAuth or API tokens are strongly preferred over direct password entry where available.

## Target Output

Primarily generates static HTML, CSS, and JavaScript websites, making them fast, secure, and easy to host on various platforms.