<?php

namespace Modules\WebPilotAI\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Modules\WebPilotAI\Events\WebsiteGenerationSucceeded;
use Modules\WebPilotAI\Listeners\SendWebsiteGenerationSuccessNotification;
use Modules\WebPilotAI\Events\WebsiteGenerationFailed;
use Modules\WebPilotAI\Listeners\SendWebsiteGenerationFailureNotification;
use Modules\WebPilotAI\Events\WebsiteDeploymentSucceeded;
use Modules\WebPilotAI\Listeners\SendWebsiteDeploymentSuccessNotification;
use Modules\WebPilotAI\Events\WebsiteDeploymentFailed;
use Modules\WebPilotAI\Listeners\SendWebsiteDeploymentFailureNotification;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event to listener mappings for the application.
     *
     * @var array<class-string, array<int, class-string>>
     */
    protected $listen = [
        WebsiteGenerationSucceeded::class => [
            SendWebsiteGenerationSuccessNotification::class,
        ],
        WebsiteGenerationFailed::class => [
            SendWebsiteGenerationFailureNotification::class,
        ],
        WebsiteDeploymentSucceeded::class => [
            SendWebsiteDeploymentSuccessNotification::class,
        ],
        WebsiteDeploymentFailed::class => [
            SendWebsiteDeploymentFailureNotification::class,
        ],
    ];

    /**
     * Register any events for your application.
     */
    public function boot(): void
    {
        parent::boot();
    }

    // You can add shouldDiscoverEvents() method if you prefer event discovery
    // public function shouldDiscoverEvents(): bool { return true; }
}