<?php

namespace Modules\WebPilotAI\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Modules\WebPilotAI\Models\Website;

class WebsiteGeneratedSuccessfully extends Mailable
{
    use Queueable, SerializesModels;

    public Website $website;

    /**
     * Create a new message instance.
     */
    public function __construct(Website $website)
    {
        $this->website = $website;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Your AI Website "' . ($this->website->name ?: 'Untitled') . '" is Ready!',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'webpilotai::emails.generation.success', // We'll create this Blade view next
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}