<?php

namespace Modules\WebPilotAI\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Modules\WebPilotAI\Events\WebsiteGenerationSucceeded;
use Modules\WebPilotAI\Mail\WebsiteGeneratedSuccessfully;

class SendWebsiteGenerationSuccessNotification implements ShouldQueue
{
    use InteractsWithQueue;

    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(WebsiteGenerationSucceeded $event): void
    {
        if ($event->website->user && $event->website->user->email) {
            Mail::to($event->website->user->email)
                ->send(new WebsiteGeneratedSuccessfully($event->website));
            Log::info("Sent WebsiteGenerationSucceeded email to {$event->website->user->email} for website ID: {$event->website->id}");
        } else {
            Log::warning("Could not send WebsiteGenerationSucceeded email: User or user email missing for website ID: {$event->website->id}");
        }
    }
}