<?php

namespace Modules\StripeGateway\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Factory;

class StripeGatewayServiceProvider extends ServiceProvider
{
    /**
     * @var string $moduleName
     */
    protected string $moduleName = 'StripeGateway';

    /**
     * @var string $moduleNameLower
     */
    protected string $moduleNameLower = 'stripegateway';

    public function boot(): void
    {
        $this->registerConfig();
        $this->loadMigrationsFrom(module_path($this->moduleName, 'Database/Migrations'));
        // $this->registerTranslations(); // Add if you have them
        // $this->registerViews();      // Add if you have them

        // Route loading is handled by the main app's RouteServiceProvider loop for modules.
        // $this->loadRoutesFrom(module_path($this->moduleName, 'Routes/web.php'));
        // $this->loadRoutesFrom(module_path($this->moduleName, 'Routes/admin.php')); // Note: path should be Routes/admin.php
        // $this->loadRoutesFrom(module_path($this->moduleName, 'Routes/api.php'));
    }

    public function register(): void
    {
        // Route registration is handled by the main app's RouteServiceProvider loop for modules.
        // if (file_exists(module_path($this->moduleName, 'Providers/RouteServiceProvider.php'))) {
        //     $this->app->register(module_path($this->moduleName, 'Providers/RouteServiceProvider.php'));
        // }
    }

    protected function registerConfig(): void
    {
        $this->publishes([
            module_path($this->moduleName, 'config/config.php') => config_path($this->moduleNameLower . '.php'),
        ], 'config');
        $this->mergeConfigFrom(
            module_path($this->moduleName, 'config/config.php'), $this->moduleNameLower
        );
    }

    public function provides(): array
    {
        return [];
    }
}