<?php

namespace Modules\StripeGateway\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    protected string $name = 'ModuleName'; // Replace ModuleName

    public function boot(): void
    {
        parent::boot();
    }

    public function map(): void
    {
        $this->mapApiRoutes();
        $this->mapWebRoutes();
        // $this->mapAdminRoutes(); // <--- THIS LINE SHOULD BE COMMENTED OUT OR REMOVED
    }

    protected function mapWebRoutes(): void
    {
        Route::middleware('web')
             ->group(module_path($this->name, '/Routes/web.php'));
    }

    protected function mapApiRoutes(): void
    {
        Route::middleware('api')
             ->prefix('api') // Or 'api/' . strtolower($this->name) if you want module-specific API prefixes
             ->name('api.')   // Or 'api.' . strtolower($this->name) . '.'
             ->group(module_path($this->name, '/Routes/api.php'));
    }

    // This entire method should be removed or its call in map() removed
    // if the main app's RouteServiceProvider handles module admin routes.
    /*
    protected function mapAdminRoutes(): void
    {
        Route::middleware(['web', \App\Http\Middleware\IsAdminMiddleware::class])
             ->prefix('admin/' . strtolower($this->name))
             ->name('admin.' . strtolower($this->name) . '.')
             ->group(module_path($this->name, '/Routes/admin.php'));
    }
    */
}
